package com.baijiayun.openapi.sdk.dto.smallcourse;

import com.baijiayun.openapi.sdk.utils.UnixTimestampSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetRoomCostReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] product_type 产品线类型（老账号填0 新账号填2）
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * [必填] date 日期
     */
    @JsonSerialize(using = UnixTimestampSerializer.class)
    private Date date;
}