package com.baijiayun.openapi.sdk.dto.roomdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data
public class GetCodeUsageBatchReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 教室ID
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] date YYYY-MM-DD格式，如：2020-11-01
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;

    /**
     * [必填] code 参加码，多个以英文逗号分隔，单次最多支持1000个
     */
    private String code;
}