package com.baijiayun.openapi.sdk.dto.roomdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data
public class ExportLiveReportReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 教室号
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 可选值 all:所有用户 student:学员 teacher:老师 admin:助教，默认只导出学员观看记录
     * 默认值 student
     * @see com.baijiayun.openapi.sdk.enums.BjyLiveReportType
     */
    private String type;

    /**
     * 分页参数
     */
    private Integer page;

    /**
     * 每页返回条数，如果不传则返回所有的
     */
    @JsonProperty("page_size")
    private Integer pageSize;

    /**
     * 查询日期，格式如：2018-03-02
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;

    /**
     * 是否返回进出明细 ，传1则返回
     */
    private Integer detail;
}