package com.baijiayun.openapi.sdk.dto.roomdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ExportChatMsgDto implements Serializable {
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;// 消息发送时间
    @JsonProperty("user_number")
    private String userNumber; // 用户ID
    @JsonProperty("user_role")
    private Integer userRole;// 用户角色 0:学生 1:老师 2:助教
    @JsonProperty("user_name")
    private String userName;// 用户昵称
    private String content;// 消息内容
    private String avatar;// 用户头像
    private String area;// ip地域信息
    private String ip;// ip信息
    private Integer filter;// 是否过滤当前聊天
    @JsonProperty("group_id")
    private Integer groupId;// 分组id
    @JsonProperty("group_name")
    private String groupName;// 分组名称
}
