package com.baijiayun.openapi.sdk.dto.room;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ListVirtualChatDto implements Serializable {

    private Long id;

    @JsonProperty("room_id")
    private String roomId;

    @JsonProperty("preset_second")
    private Integer presetSecond;

    private String content;

    @JsonProperty("cycle_times")
    private Integer cycleTimes;

    @JsonProperty("create_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @JsonProperty("update_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * 开课后发送时间点，格式为 HH:mm:ss。例如：开课后30秒发送 00:00:30
     */
    @JsonProperty("send_time")
    private String sendTime;

}
