package com.baijiayun.openapi.sdk.dto.room;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.Data;

@Data
public class ListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 页数，参加码数量过多时，可以分多页来获取，每页取limit条。默认值为1
     */
    private Integer page;

    /**
     * 每页获取的条数，默认值100，最大值不能超过1000
     */
    private Integer limit;

    /**
     * 1:教育直播 默认值0
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * 直播状态，默认0全部状态，1未开播，2直播中，3已开播，4回放中（开启跳转回放并回放已生成）
     */
    @JsonProperty("new_live_status")
    private Integer newLiveStatus;
}