package com.baijiayun.openapi.sdk.dto.room;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class ListCodeReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 房间ID
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 0表示普通参加码 1表示试听参加码 默认值0
     */
    private Integer type;

    /**
     * 页数，参加码数量过多时，可以分多页来获取，每页取limit条。默认值为1
     */
    private Integer page;

    /**
     * 每页获取的条数，默认值100，最大值不能超过1000
     */
    private Integer limit;
}