package com.baijiayun.openapi.sdk.dto.room;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class GetGroupLiveCodesByUserRoleReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 教室号
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] user_role 角色，0:学生 1:老师 2:助教
     * @see com.baijiayun.openapi.sdk.enums.BjyUserRole
     */
    @JsonProperty("user_role")
    private Integer userRole;

    /**
     * 页码，默认1
     */
    private Integer page;

    /**
     * 条数，默认50
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}