package com.baijiayun.openapi.sdk.dto.room;

import com.baijiayun.openapi.sdk.enums.BjyEnableLiveSell;
import com.baijiayun.openapi.sdk.utils.UnixTimestampSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class CreateReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] title 直播课标题，不超过20个字符或汉字，超过部分将进行截取
     */
    private String title;

    /**
     * [必填] start_time 开课时间,unix时间戳（秒）
     */
    @JsonProperty("start_time")
    @JsonSerialize(using = UnixTimestampSerializer.class)
    private Date startTime;

    /**
     * [必填] end_time 下课时间,unix时间戳（秒）
     */
    @JsonProperty("end_time")
    @JsonSerialize(using = UnixTimestampSerializer.class)
    private Date endTime;

    /**
     * 1:一对一课2:普通大班课3:小班课普通版4:小班课专业版（需开通相关权限才可以创建）默认为普通大班课
     * @see com.baijiayun.openapi.sdk.enums.BjyRoomType
     */
    private Integer type;

    /**
     * 0:表示教育
     */
    @JsonProperty("industry_type")
    private Integer industryType;

    /**
     * 房间最大人数,不传或传0表示不限制。注：一对一是1人，互动小班课人数不能超过10人，普通大班课可以不设置人数上限
     */
    @JsonProperty("max_users")
    private Integer maxUsers;

    /**
     * 学生可提前进入的时间，单位为秒，默认为30分钟
     */
    @JsonProperty("pre_enter_time")
    private Integer preEnterTime;

    /**
     * 是否是长期房间，0:普通房间 1:长期房间。默认为普通房间
     * (注1：普通房间时长小于24小时)
     * (注2：需要给账号开通长期房间权限才可以创建长期房间)
     */
    @JsonProperty("is_long_term")
    private Integer isLongTerm;

    /**
     * 可选值：doubleCamera(双摄像头)、classic(经典模板)、triple(三分屏)、oneone(单视频模板)、oneoneNew(单视频模板2)
     * 默认triple
     */
    @JsonProperty("template_name")
    private String templateName;

    /**
     * 可选值, APP端模板样式，1是横屏，2是竖屏;
     */
    @JsonProperty("app_template")
    private Integer appTemplate;

    /**
     * 学生发言时是否自动开启摄像头1:开启2:不开启默认会开启
     * @see com.baijiayun.openapi.sdk.enums.BjySpeakCameraTurnOnEnum
     */
    @JsonProperty("speak_camera_turnon")
    private Integer speakCameraTurnon;

    /**
     * 老师是否启用设备检测1:启用2:不启用默认不启用
     */
    @JsonProperty("teacher_need_detect_device")
    private Integer teacherNeedDetectDevice;

    /**
     * 学生是否启用设备检测1:启用2:不启用默认不启用
     */
    @JsonProperty("student_need_detect_device")
    private Integer studentNeedDetectDevice;

    /**
     * 指定不能观看的客户端，可选值（web:pc浏览器, h5:手机浏览器）多种以英文逗号分隔
     */
    @JsonProperty("forbidden_end_types")
    private String forbiddenEndTypes;

    /**
     * 是否以视频为主，1=以视频为主，2=以PPT为主，0或不传使用默认值
     */
    @JsonProperty("is_video_main")
    private Integer isVideoMain;

    /**
     * 手机端模板是否以视频为主，1=以视频为主，2=以PPT为主，0或不传使用默认值
     */
    @JsonProperty("m_is_video_main")
    private Integer mIsVideoMain;

    /**
     * 1:分组直播 2:分组大小班直播 0:普通直播
     */
    @JsonProperty("is_group_live")
    private Integer isGroupLive;

    /**
     * 是不是是伪直播 0:否  1:是
     */
    @JsonProperty("is_mock_live")
    private Integer isMockLive;

    /**
     * 是否是推流直播，0:常规直播 1:推流直播 2: 伪直播
     * 默认是常规直播（注：需要给账号开通推流直播的权限）
     * @see com.baijiayun.openapi.sdk.enums.BjyLiveType
     */
    @JsonProperty("is_push_live")
    private Integer isPushLive;

    /**
     * 是否是webrtc课程 0:不是 1:是
     */
    @JsonProperty("is_webrtc_live")
    private Integer isWebrtcLive;

    /**
     * 是否加密，0=不加密 1=加密
     */
    @JsonProperty("is_encrypt")
    private Integer isEncrypt;

    /**
     * 研讨会模式，仅在new_group_live为2时支持
     */
    @JsonProperty("is_discuss_live")
    private Integer isDiscussLive;

    /**
     * 是否是通过手机验证进入
     * <ul>
     *  <li>0 直接进教室</li>
     *  <li>1 课程私密参加码</li>
     *  <li>2 公开参加码</li>
     *  <li>3 白名单进教室</li>
     *  <li>4 密码观看</li>
     *  <li>5 云端直播白名单</li>
     *  <li>6 手机验证</li>
     * </ul>
     * <p>默认值: 0</p>
     */
    @JsonProperty("is_private")
    private Integer isPrivate;

    /**
     * 是否是智能直播（真伪直播）（仅线上双师班型生效）
     */
    @JsonProperty("is_live_and_mock_live")
    private Integer isLiveAndMockLive;

    /**
     * 伪直播关联的回放教室号
     */
    @JsonProperty("mock_room_id")
    private String mockRoomId;

    /**
     * 伪直播关联的回放教室session_id（针对长期房间）
     */
    @JsonProperty("mock_session_id")
    private String mockSessionId;

    /**
     * 伪直播关联的点播视频ID
     */
    @JsonProperty("mock_video_id")
    private String mockVideoId;

    /**
     * 伪直播自动录制 1：是，0：否
     */
    @JsonProperty("mock_live_record")
    private Integer mockLiveRecord;

    /**
     * 伪直播设置循环播放次数
     */
    @JsonProperty("mock_live_play_times")
    private Integer mockLivePlayTimes;

    /**
     * 推流直播自动录制 1：是，0：否
     */
    @JsonProperty("push_live_record")
    private Integer pushLiveRecord;

    /**
     * 学生私聊角色，0：全部，1：老师，2：助教
     */
    @JsonProperty("student_private_chat_role")
    private Integer studentPrivateChatRole;

    /**
     * 是否允许APP分享 1:允许 2:不允许 0或不传则使用默认值，默认是允许
     */
    @JsonProperty("enable_share")
    private Integer enableShare;

    /**
     * 分组课堂/线上双师 成员名单数据权限 0:成员只看组内权限 1:成员可看全部权限
     * <p>0或不传则使用默认值，默认是成员只看组内权限</p>
     */
    @JsonProperty("enable_group_users_public")
    private Integer enableGroupUsersPublic;

    /**
     * 分组/线上双师 助教查看答题数据权限 0:助教查看组内答题数据 1:助教查看全部数据
     * <p>0或不传则使用默认值，默认是助教查看组内答题数据</p>
     */
    @JsonProperty("group_admin_permission")
    private Integer groupAdminPermission;

    /**
     * 分组直播/线上双师 成员聊天数据权限 0:成员只看组内权限 1:成员可看全部权限
     * <p>0或不传则使用默认值，默认是成员只看组内权限</p>
     */
    @JsonProperty("enable_group_chat_public")
    private Integer enableGroupChatPublic;

    /**
     * 伪直播,是否同步回放聊天消息 0：不同步 1：同步
     */
    @JsonProperty("enable_mock_sync_chat_message")
    private Integer enableMockSyncChatMessage;

    /**
     * 虚拟话术开关 0：关闭 1：开启
     */
    @JsonProperty("enable_set_virtual_chat_art")
    private Integer enableSetVirtualChatArt;

    /**
     *  消息审核 0 关 1 开
     * */
    @JsonProperty("enable_room_chat_check")
    private Integer enableRoomChatCheck;

    /**
     *  伪直播 同步回放虚拟话术
     * */
    @JsonProperty("enable_mock_sync_chat_art")
    private Integer enableMockSyncChatArt;

    /**
     * 直播类型：0:全局模版 1:自定义模版 2:纯视频 3:系统模版
     */
    @JsonProperty("enable_custom_menu")
    private String enableCustomMenu;

    /**
     * 回放类型： 0:全局模版 1:自定义模版 2:纯视频 3:系统模版
     */
    @JsonProperty("playback_custom_menu_type")
    private String playbackCustomMenuType;

    /**
     * 微信用户获取昵称 1：启用，2：不启用
     * <p>默认值: 1</p>
     */
    @JsonProperty("enable_weixin_auth")
    private Integer enableWeixinAuth;

    /**
     * 系统自动分配昵称 1：启用，0：不启用
     * <p>默认值: 0</p>
     */
    @JsonProperty("system_auto_allocate_name")
    private Integer systemAutoAllocateName;

    /**
     * 是否分组，0:常规直播 1:分组课堂（注：需要给账号开通相关权限才可以创建分组直播，必须同时指定参数type为2）2:线上双师（注：需要权限，参数type须为2）
     */
    @JsonProperty("new_group_live")
    private Integer newGroupLive;

    /**
     * 有无学生上麦，仅在webrtc班型上使用此参数 0：无，1：有
     * <p>默认值: 0</p>
     */
    @JsonProperty("has_student_raise")
    private Integer hasStudentRaise;

    /**
     * 小班课教室白板url
     */
    @JsonProperty("whiteboard_url")
    private String whiteboardUrl;

    /**
     * 小班课教室背景url
     */
    @JsonProperty("background_url")
    private String backgroundUrl;

    /**
     * 小班课统计是否有海外用户 1：否，2：是 默认是1
     */
    @JsonProperty("has_foreign_user")
    private Integer hasForeignUser;

    /**
     * [必填] end_delay_time 课程预设的下课时间后可以拖堂的时间，到时间会强制下课，单位（秒），0不强制，大于0生效
     */
    @JsonProperty("end_delay_time")
    private Integer endDelayTime;

    /**
     * 大班下课后操作，0:回到小班,1:全员下课 默认0
     */
    @JsonProperty("class_end_operation")
    private Integer classEndOperation;

    /**
     * 课中是否允许切班，1:不允许,0:允许 默认0，如果不允许，配置该字段需要将switch_room_role设置为1，否则不生效
     */
    @JsonProperty("disable_switch_class")
    private Integer disableSwitchClass;

    /**
     * 分组直播大小班切换，角色控制 1：大班 2：小班
     */
    @JsonProperty("switch_room_role")
    private Integer switchRoomRole;

    /**
     * 0=使用账号默认值（账号产品线级配置），1=开启自动云录制，2=关闭自动云录制
     */
    @JsonProperty("auto_playback_record")
    private Integer autoPlaybackRecord;

    /**
     * 是否允许只拉其它学生音频流 0:拉音视频流，1：只拉音频，默认都拉,只支持小班课只有1V8~1V12的班型才能设置为1，其余的默认都拉
     */
    @JsonProperty("enable_pull_audio_only")
    private Integer enablePullAudioOnly;

    /**
     * 小程序模板属性，h5为单视频，normal为多视频，默认多视频模板
     */
    @JsonProperty("miniprogram_template")
    private String miniprogramTemplate;

    /**
     * [必填] enable_live_sell 是否使用带货直播模板。0:不使用 1:纯视频带货模板 2:ppt 带货模板
     * (选择纯视频带货模板时,后面参数使用固定值,is_video_main=1,m_template=2,miniprogram_template='normal')
     * @see BjyEnableLiveSell
     */
    @JsonProperty("enable_live_sell")
    private Integer enableLiveSell;

    /**
     * 开启直播带货PPT模版后，视频是否在PPT上方，用于PPT三分屏模板。
     */
    @JsonProperty("live_sell_video_up_with_doc")
    private Integer liveSellVideoUpWithDoc;

    /**
     * 是否开启三分屏带货，0不开启，1开启（仅enable_live_sell=0生效）
     */
    @JsonProperty("sell_goods_in_large_class")
    private Integer sellGoodsInLargeClass;

    /**
     * 是否开启美颜功能，默认读取账号配置。0:不开启，1开启
     */
    @JsonProperty("enable_beauty")
    private Integer enableBeauty;

    /**
     * 是否开启虚拟背景功能，默认读取账号配置，0不开启，1开启
     */
    @JsonProperty("enable_sticker")
    private Integer enableSticker;

    /**
     * 开启直播结束后，自动跳转到回放地址
     */
    @JsonProperty("enable_end_link_to_playback")
    private Integer enableEndLinkToPlayback;

    /**
     * PC支持进入直播间
     */
    @JsonProperty("enable_live_sell_pc_student")
    private Integer enableLiveSellPcStudent;

    /**
     * 伪直播同步回放商品功能显示开关 1：开启，0:关闭，默认0
     */
    @JsonProperty("enable_mocklive_goods")
    private Integer enableMockLiveGoods;

    /**
     * 伪直播同步回放商品功能显示开关 1：开启，0:关闭，默认0
     */
    @JsonProperty("enable_mock_live_coupon")
    private Integer enableMockLiveCoupon;

    /**
     * 回放发消息 1：开启，0:关闭
     */
    @JsonProperty("enable_playback_chat")
    private Integer enablePlaybackChat;

    /**
     * 回放消息审核 1：开启，0:关闭，
     */
    @JsonProperty("enable_playback_chat_check")
    private Integer enablePlaybackChatCheck;

    /**
     * 是否使用全局黑名单 1：开启，0:关闭，默认1
     */
    @JsonProperty("enable_live_global_blacklist")
    private Integer enableLiveGlobalBlacklist;

    /**
     * 是否是点播 1:是 0:否 默认0
     */
    @JsonProperty("is_video_live")
    private Integer isVideoLive;

    /**
     * 点播视频id
     */
    @JsonProperty("video_unique")
    private String videoUnique;

    /**
     *  0 竖屏，1 横屏
     * */
    @JsonProperty("enable_horizontal_template")
    private Integer enableHorizontalTemplate;
}