package com.baijiayun.openapi.sdk.dto.room;

import com.baijiayun.openapi.sdk.utils.UnixTimestampSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class CreateDoubleTeacherLiveReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] title 直播课标题，不超过50个字符或汉字，超过部分将进行截取
     */
    private String title;

    /**
     * [必填] start_time 开课时间，时间戳
     */
    @JsonProperty("start_time")
    @JsonSerialize(using = UnixTimestampSerializer.class)
    private Date startTime;

    /**
     * [必填] end_time 下课时间，时间戳
     */
    @JsonProperty("end_time")
    @JsonSerialize(using = UnixTimestampSerializer.class)
    private Date endTime;

    /**
     * 0：普通房间 1：长期房间
     */
    @JsonProperty("is_long_term")
    private Integer isLongTerm;

    /**
     * 双师教室容量，传0表示不限制
     */
    @JsonProperty("max_users")
    private Integer maxUsers;

    /**
     * 大直播容量，传0表示不限制
     */
    @JsonProperty("bind_room_max_users")
    private Integer bindRoomMaxUsers;
}