package com.baijiayun.openapi.sdk.dto.room;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Created by chenjiaqiang on 2024/06/13
 **/
@Data
public class BroadcastShoppingOrderReq implements Serializable {

    @JsonProperty("room_id")
    private String roomId;

    @JsonProperty("user_name")
    private String userName;

    /**
     * live_goods_rel.bjy_goods_id
     */
    @JsonProperty("goods_id")
    private Long goodsId;

    @JsonProperty("order_id")
    private String orderId;

    @JsonProperty("order_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date orderTime;
}
