package com.baijiayun.openapi.sdk.dto.room;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class AddVirtualChatReq implements Serializable {

    @JsonProperty("room_id")
    private String roomId;

    private String content;

    /**
     * 开课后发送时间点，格式为 HH:mm:ss。例如：开课后30秒发送 “00:00:30”。
     *
     * <p>预设发送时间范围00:00:01-06:00:00，超过这个范围会报错。</p>
     */
    @JsonProperty("send_time")
    private String sendTime;

    @JsonProperty("cycle_times")
    private Integer cycleTimes;
}
