package com.baijiayun.openapi.sdk.dto.reportdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetProductLinkClickListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 商品链接
     */
    @JsonProperty("product_link")
    private String productLink;

    /**
     * 开始时间，默认今日 00:00:00 时
     */
    @JsonProperty("start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * 结束时间，默认今日 23:59:59 时
     */
    @JsonProperty("end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 页数
     */
    private Integer page;

    /**
     * 页面大小 默认1000
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}