package com.baijiayun.openapi.sdk.dto.pay;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetRevenueListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 交易类型：1 充值，2 扣费
     */
    @JsonProperty("op_type")
    private Integer opType;

    /**
     * 产品线类型： 1大班课，2小班课，3双师，4企业直播，5点播
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * 交易时间范围开始时间，例如：2022-08-10 22:11:12
     */
    @JsonProperty("start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * 交易时间范围结束时间，例如：2022-08-11 22:11:12
     */
    @JsonProperty("end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 分页页数
     */
    private Integer page;

    /**
     * 分页大小
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}