package com.baijiayun.openapi.sdk.dto.partner;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class GetPartnerConfigReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] keys 需要查询用户配置项key，多个以英文逗号分隔，例 "live_screen_frame_interval,live_doc_watermark.font_size"
     */
    private String keys;

    /**
     * [必填] product_type 产品线ID，0默认值 1大班课，2小班课，3双师，4企业直播，5点播，6微课
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;
}