package com.baijiayun.openapi.sdk.dto.newsub;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class SetLiveAccountReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] sub_partner_id 子账号partner_id
     */
    @JsonProperty("sub_partner_id")
    private String subPartnerId;

    /**
     * [必填] product_type 产品线
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * 可用并发 ，仅对并发计费账号有效
     */
    @JsonProperty("user_limit")
    private Integer userLimit;

    /**
     * 最大可用并发，仅对并发计费账号有效
     */
    @JsonProperty("max_user_limit")
    private Integer maxUserLimit;

    /**
     * 产品线开关，0关1开
     */
    private Integer status;

    /**
     * 可上麦人数
     */
    @JsonProperty("live_max_speakers")
    private Integer liveMaxSpeakers;
}