package com.baijiayun.openapi.sdk.dto.newsub;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class AddSubAccountReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] mobile 手机号
     */
    private String mobile;

    /**
     * [必填] email 邮箱
     */
    private String email;

    /**
     * [必填] password password
     */
    private String password;

    /**
     * [必填] effect_time 生效时间
     */
    @JsonProperty("effect_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectTime;

    /**
     * [必填] expire_time 失效时间
     */
    @JsonProperty("expire_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date expireTime;

    /**
     * [必填] large_class_user_limit 大班课并发计费模式的并发上限，其他计费类型设置此字段没有作用
     */
    @JsonProperty("large_class_user_limit")
    private Integer largeClassUserLimit;

    /**
     * [必填] large_class_max_user_limit 大班课并发计费模式可超出使用的并发上限，其他计费类型设置此字段没有作用
     */
    @JsonProperty("large_class_max_user_limit")
    private Integer largeClassMaxUserLimit;

    /**
     * [必填] business_user_limit 企业直播并发计费模式的并发上限，其他计费类型设置此字段没有作用
     */
    @JsonProperty("business_user_limit")
    private Integer businessUserLimit;

    /**
     * [必填] business_max_user_limit 企业直播并发计费模式可超出使用的并发上限，其他计费类型设置此字段没有作用
     */
    @JsonProperty("business_max_user_limit")
    private Integer businessMaxUserLimit;

    /**
     * [必填] large_class_live_max_speakers 大班课可上麦人数
     */
    @JsonProperty("large_class_live_max_speakers")
    private Integer largeClassLiveMaxSpeakers;

    /**
     * [必填] business_live_max_speakers 企业直播可上麦人数
     */
    @JsonProperty("business_live_max_speakers")
    private Integer businessLiveMaxSpeakers;

    /**
     * [必填] large_class_status 是否开通大班课产品线, 0否，1是
     */
    @JsonProperty("large_class_status")
    private Integer largeClassStatus;

    /**
     * [必填] small_class_status 是否开通小班课产品线, 0否，1是
     */
    @JsonProperty("small_class_status")
    private Integer smallClassStatus;

    /**
     * [必填] business_status 是否开通企业直播产品线, 0否，1是
     */
    @JsonProperty("business_status")
    private Integer businessStatus;

    /**
     * [必填] credit_money 子账号信用额度
     */
    @JsonProperty("credit_money")
    private Integer creditMoney;

    /**
     * [必填] flow 流量,按量计费设置此字段不生效
     */
    private Integer flow;

    /**
     * [必填] max_flow 最大可使用的流量，按量计费设置此字段不生效
     */
    @JsonProperty("max_flow")
    private Integer maxFlow;

    /**
     * [必填] storage_limit 存储，按量计费设置此字段不生效
     */
    @JsonProperty("storage_limit")
    private Integer storageLimit;

    /**
     * [必填] max_storage_limit 最大可使用的存储，按量计费设置此字段不生效
     */
    @JsonProperty("max_storage_limit")
    private Integer maxStorageLimit;

    /**
     * [必填] company 公司
     */
    private String company;

    /**
     * [必填] contacts 联系人
     */
    private String contacts;

    /**
     * [必填] video_status 点播状态
     */
    @JsonProperty("video_status")
    private Integer videoStatus;
}