package com.baijiayun.openapi.sdk.dto.luckbag;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.Date;

@Data
public class CouponCreateResp {

    private Long id;

    @JsonProperty("partner_id")
    private String partnerId;

    @JsonProperty("coupon_batch_no")
    private String couponBatchNo;

    @JsonProperty("coupon_title")
    private String couponTitle;

    private Double money;

    private Integer total;

    @JsonProperty("create_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    String callback;

    /**
     * 有效期类型 0:固定时间范围 1:领取后固定天数有效
     * 默认值: 0
     */
    @JsonProperty("validity_time_type")
    private Integer validityTimeType;

    /**
     * 领取后有效天数，validity_time_type=1时生效
     * 默认值: 0
     */
    @JsonProperty("draw_validity_day")
    private Integer drawValidityDay;
}
