package com.baijiayun.openapi.sdk.dto.luckbag;

import com.baijiayun.openapi.sdk.utils.DoublePrecisionSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class CouponCreateReq implements Serializable {

    /**
     * 优惠券名称
     */
    @JsonProperty("coupon_title")
    private String couponTitle;

    /**
     * 优惠券类型:0: 满减券 1:直减券 2:折扣券
     *
     * @see com.baijiayun.openapi.sdk.enums.BjyCouponType
     */
    private Integer type;

    /**
     * 库存总量
     */
    private Integer total;

    /**
     * 折扣。只支持小数点后2位，取值范围0.01-9.99
     */
    @JsonSerialize(using = DoublePrecisionSerializer.class)
    private Double discount;

    /**
     * 商品满减券-减X，只支持整数、商品直减券-减X，小数点后2位
     */
    @JsonSerialize(using = DoublePrecisionSerializer.class)
    private Double money;

    /**
     * 领券开始时间
     */
    @JsonProperty("valid_start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date validStartTime;

    /**
     * 领券结束时间
     */
    @JsonProperty("valid_end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date validEndTime;

    /**
     * 商品满减券-满X，只支持整数
     */
    @JsonProperty("mini_charge_money")
    @JsonSerialize(using = DoublePrecisionSerializer.class)
    private Double miniChargeMoney;

    /**
     *  优惠券回调地址
     *  带上回调域名
     * */
    private String callback;

    /**
     * 有效期类型 0:固定时间范围 1:领取后固定天数有效
     * 默认值: 0
     */
    @JsonProperty("validity_time_type")
    private Integer validityTimeType;

    /**
     * 领取后有效天数，validity_time_type=1时生效
     * 默认值: 0
     */
    @JsonProperty("draw_validity_day")
    private Integer drawValidityDay;

    /**
     * 个人领取数量 0不限 >1数量
     * 默认值: 1
     */
    @JsonProperty("restrict_num")
    private Integer restrictNum;
}
