package com.baijiayun.openapi.sdk.dto.livesetting;

import com.baijiayun.openapi.sdk.utils.DoublePrecisionSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;

@Data
public class SetLiveHorseLampResp implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 0 关闭 1固定值 2 昵称 3固定值+昵称
     */
    private Integer type;

    /**
     * 跑马灯
     */
    private String value;

    /**
     * 颜色#ffffff
     */
    private String color;

    /**
     * 直播跑马灯字体大小
     */
    @JsonProperty("font_size")
    private Integer fontSize;

    /**
     * 直播跑马灯不透明度
     */
    @JsonSerialize(using = DoublePrecisionSerializer.class)
    private Double opacity;

    /**
     * 字体是否加粗，0不加粗，1加粗
     */
    @JsonProperty("font_bold")
    private Integer fontBold;

    /**
     * 背景颜色#ffffff
     */
    @JsonProperty("background_color")
    private String backgroundColor;

    /**
     * 背景透明度
     */
    @JsonProperty("background_opacity")
    @JsonSerialize(using = DoublePrecisionSerializer.class)
    private Double backgroundOpacity;

    /**
     * 显示方式，roll滚动，blink闪烁（默认roll）
     */
    @JsonProperty("display_mode")
    private String displayMode;

    /**
     * 滚动显示间隔秒数(默认30s)
     */
    @JsonProperty("display_roll_duration")
    private Integer displayRollDuration;

    /**
     * 闪烁显示间隔秒数(默认3s)
     */
    @JsonProperty("display_blink_duration")
    private Integer displayBlinkDuration;
}