package com.baijiayun.openapi.sdk.dto.livesetting;

import com.baijiayun.openapi.sdk.enums.BjyExemptWordMatchType;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2024/7/10
 */
@Data
public class GetChatExemptWordsDto implements Serializable {

    /**
     * 免审词ID
     */
    private Long id;

    /**
     * 合作者ID
     */
    @JsonProperty("partner_id")
    private String partnerId;

    /**
     * 免审词
     */
    private String word;

    /**
     * 匹配类型 1:精准匹配 2:模糊匹配
     * @see BjyExemptWordMatchType
     */
    @JsonProperty("match_type")
    private Integer matchType;

    /**
     * 创建时间
     */
    @JsonProperty("create_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 更新时间
     */
    @JsonProperty("update_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
}
