package com.baijiayun.openapi.sdk.dto.liveaccount;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetDateUserCountReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] product_type 产品线，1大班课，2小班课，4企业直播
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * [必填] start_date 起始日期
     */
    @JsonProperty("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * [必填] end_date 结束日期
     */
    @JsonProperty("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;
}