package com.baijiayun.openapi.sdk.dto.live;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 发送消息的用户信息
 *
 * @author yanmaoyuan
 * @date 2024/7/2
 */
@Data
public class SendChatMessageFrom implements Serializable {
    private String id;// 教室内user_id
    private String number;// 教室内user_number
    /**
     * 发消息人的身份 0 学生 1 老师 2 助教
     * @see com.baijiayun.openapi.sdk.enums.BjyUserRole
     */
    private Integer type;
    private String name;// 昵称
    private String avatar;// 头像
    @JsonProperty("real_name")
    private String realName;// 用于在场控端显示真是发送消息的用户名
    /**
     * 教室内人状态 0 显身 1 隐身 ，传0固定
     */
    private Integer status = 0;
    /**
     * 终端类型
     * @see com.baijiayun.openapi.sdk.enums.BjyClientType
     */
    @JsonProperty("end_type")
    private Integer endType = 0;// 传0
    private Integer group = 0;// 传0
    @JsonProperty("webrtc_support")
    private Integer webrtcSupport = 1;// 是否支持webrtc
}
