package com.baijiayun.openapi.sdk.dto.interactinfo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetInteractListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] type 签到类型
     */
    private String type;

    /**
     * [必填] begin_time 统计开始时间
     */
    @JsonProperty("begin_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date beginTime;

    /**
     * [必填] end_time 统计结束时间
     */
    @JsonProperty("end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 房间号
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 页码
     */
    private Integer page;

    /**
     * 每页大小
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}