package com.baijiayun.openapi.sdk.dto.interactinfo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetInteractDetailReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 教室id
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] type 类型，默认：checkin
     */
    private String type;

    /**
     * 页数
     */
    private Integer page;

    /**
     * 每页数据条数
     */
    @JsonProperty("page_size")
    private Integer pageSize;

    /**
     * 统计的开始时间 0000-00-00 00:00:00
     */
    @JsonProperty("begin_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date beginTime;

    /**
     * 统计的开始时间 0000-00-00 00:00:00
     */
    @JsonProperty("end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;
}