package com.baijiayun.openapi.sdk.dto.interactdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetRedPackageDataReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 教室id和设备id不可同时为空
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 教室id和设备id不可同时为空
     */
    @JsonProperty("device_id")
    private Long deviceId;

    /**
     * 不传代表所有红包类型 0：普通红包 1：拼手气红包
     */
    private Integer type;

    /**
     * 页数
     */
    private Integer page;

    /**
     * 每页数据条数
     */
    @JsonProperty("page_size")
    private Integer pageSize;

    /**
     * 开始日期，格式类似2019-10-10，与end_date必须同时填写
     */
    @JsonProperty("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * 结束日期，格式类似2019-10-10，与start_date必须同时填写
     */
    @JsonProperty("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;
}