package com.baijiayun.openapi.sdk.dto.h5template;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class SetTemplateStatusReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 类型，1:直播菜单，2:回放菜单
     */
    @JsonProperty("live_type")
    private Integer liveType;

    /**
     * [必填] product_type 产品线类型，1:大班课
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * [必填] template_id 模版 id
     */
    @JsonProperty("template_id")
    private Long templateId;

    /**
     * 是否使用全局模版，1:是，0:否，默认是
     */
    private Integer status;
}