package com.baijiayun.openapi.sdk.dto.evaluation;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ExportAnswerReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 房间ID
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 产品线类型（0：老账号 1：大班课 2：小班课 3：双师 4：企业直播）
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * 长期课需要传个日期（格式：Y-m-d）
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;
}