package com.baijiayun.openapi.sdk.dto.doubleteacher;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class AddZoneReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] zone_unique 校区唯一编码，必须是数字
     */
    @JsonProperty("zone_unique")
    private Long zoneUnique;

    /**
     * [必填] area_id 校区所属城市ID
     */
    @JsonProperty("area_id")
    private Long areaId;

    /**
     * [必填] name 校区名称，长度不能超过100个字符
     */
    private String name;

    /**
     * [必填] address 校区地址，长度不可超过255个字符
     */
    private String address;
}