package com.baijiayun.openapi.sdk.dto.doc;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class UploadWithUrlReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 教室号，如果传了教室号则文档自动绑定到该教室，不传则不绑定
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 是否使用动效PPT，只针对PPT有效,1为动效
     */
    @JsonProperty("ppt_animation")
    private Integer pptAnimation;

    /**
     * [必填] file_url 要上传的文件URL。
     */
    @JsonProperty("file_url")
    private String fileUrl;

    /**
     * 设置文件的文件名，需要文件名后缀，不带后缀会上传失败，不传默认使用 url 中的文件名。支持的文档类型有： ‘.doc’, ‘.ppt’, ‘.pdf’, ‘.pptx’, ‘.docx’,’.jpg’, ‘.jpeg’, ‘.png’, ‘.gif’,’.zip’
     */
    @JsonProperty("file_name")
    private String fileName;
}