package com.baijiayun.openapi.sdk.dto.doc;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.File;
import java.io.Serializable;

@Data
public class UploadVideoDocReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] attachment 音视频文件. 音视频文件大小限制最大为 50M。只有 webrtc 底层的教室才支持播放音视频课件。音频文件支持类型：mp3、wav、wma、aac、flac、m4a、oga、opus。视频文件支持类型：mp4、3gp、mpg、mpeg、3g2、avi、flv、wmv、h264、m4v、mj2、mov、ogg、ogv、rm、rmvb、qt、webm。
     */
    private File attachment;

    /**
     * 教室ID 不传则不会绑定到教室，传了绑定到指定教室
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 上级文件目录id 0或者不传：分类到根目录
     */
    @JsonProperty("partner_finder_id")
    private Long partnerFinderId;
}