package com.baijiayun.openapi.sdk.dto.doc;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetRoomVideoListDto implements Serializable {

    /**
     * 音视频video_unique
     */
    private String fid;

    /**
     * 音视频名称
     */
    private String name;

    /**
     * 音视频大小，单位字节
     */
    @JsonProperty("total_size")
    private Long totalSize;

    /**
     * 音视频来源 management:后台 room:教室 api:OpenAPI
     */
    @JsonProperty("upload_source")
    private String uploadSource;

    /**
     * 音视频创建时间
     */
    @JsonProperty("create_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

}