package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.videoquiz.*;

/**
 * Auto generate interface of VideoQuizApi.
 */
@BjyClient
public interface VideoQuizApi {

    /**
     * API-43:获取点播弹题
     * @param partnerInfo 百家云合作者参数
     * @param videoUnique [必填] video_unique 点播视频id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_43_VIDEO_QUIZ_GETLIST)
    BjyResult<Void> getlist(BjyPartnerInfo partnerInfo, @RequestParam("video_unique") String videoUnique);

    /**
     * API-44: 编辑点播弹题接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_44_VIDEO_QUIZ_SAVE_QUES)
    BjyResult<Void> saveQues(BjyPartnerInfo partnerInfo, SaveQuesReq req);

    /**
     * API-45:删除点播弹题
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_45_VIDEO_QUIZ_DEL_QUES)
    BjyResult<Void> delQues(BjyPartnerInfo partnerInfo, DelQuesReq req);

    /**
     * API-58:获取弹题的学生答题数据
     * @param partnerInfo 百家云合作者参数
     * @param videoUnique [必填] video_unique 点播视频id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_58_VIDEO_QUIZ_GET_ANSWER_INFO)
    BjyResult<Void> getAnswerInfo(BjyPartnerInfo partnerInfo, @RequestParam("video_unique") String videoUnique);
}