package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.TotalListResp;
import com.baijiayun.openapi.sdk.dto.videodata.*;

/**
 * Auto generate interface of VideoDataApi.
 */
@BjyClient
public interface VideoDataApi {

    /**
     * API-21: 查询指定ID视频一段时间内使用的流量
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_21_VIDEO_DATA_GET_USED_FLOW)
    BjyResult<Void> getUsedFlow(BjyPartnerInfo partnerInfo, GetUsedFlowReq req);

    /**
     * API-24: 获取指定视频观看记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_24_VIDEO_DATA_GET_VIDEO_PLAY_RECORD)
    BjyResult<Void> getVideoPlayRecord(BjyPartnerInfo partnerInfo, GetVideoPlayRecordReq req);

    /**
     * API-25: 获取账号所有视频观看记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_25_VIDEO_DATA_EXPORT_VIDEO_REPORT_BATCH)
    BjyResult<Void> exportVideoReportBatch(BjyPartnerInfo partnerInfo, ExportVideoReportBatchReq req);

    /**
     * API-28: 获取播放量排行
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_28_VIDEO_DATA_GET_VIDEO_PLAY_COUNT_RANK)
    BjyResult<Void> getVideoPlayCountRank(BjyPartnerInfo partnerInfo, GetVideoPlayCountRankReq req);

    /**
     * API-29: 获取指定ID视频播放量
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_29_VIDEO_DATA_GET_VIDEO_DAILY_PLAY_COUNT)
    BjyResult<Void> getVideoDailyPlayCount(BjyPartnerInfo partnerInfo, GetVideoDailyPlayCountReq req);

    /**
     * API-30: 获取账号视频播放量
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_30_VIDEO_DATA_GET_PARTNER_DAILY_PLAY_COUNT)
    BjyResult<Void> getPartnerDailyPlayCount(BjyPartnerInfo partnerInfo, GetPartnerDailyPlayCountReq req);

    /**
     * API-38: 查询账号产品线下一天的视频流量使用明细
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_38_VIDEO_DATA_GET_USED_FLOW_DETAIL)
    BjyResult<Void> getUsedFlowDetail(BjyPartnerInfo partnerInfo, GetUsedFlowDetailReq req);

    /**
     * API 6: 获取指定回放视频观看记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_VIDEO_DATA_GET_PLAYBACK_PLAY_RECORD)
    BjyResult<TotalListResp<GetPlaybackPlayRecordDto>> getPlaybackPlayRecord(BjyPartnerInfo partnerInfo, GetPlaybackPlayRecordReq req);

    /**
     * 学生每次观看回放去重记录（该接口用于获取指定回放视频一段时间内的的观看记录，以 fid、user_number、guid、client_type 为维度去重之后观看记录。）
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_VIDEO_DATA_GET_PLAYBACK_WATCH_RECORD_WITH_GUID)
    BjyResult<Void> getPlaybackWatchRecordWithGuid(BjyPartnerInfo partnerInfo, GetPlaybackWatchRecordWithGuidReq req);

    /**
     * 学生观看回放去重记录（该接口用于获取指定回放视频一段时间内的的观看记录，以 fid、user_number 为维度去重之后观看记录。）
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_VIDEO_DATA_GET_PLAYBACK_WATCH_RECORD)
    BjyResult<Void> getPlaybackWatchRecord(BjyPartnerInfo partnerInfo, GetPlaybackWatchRecordReq req);

    /**
     * 获取回放观看和直播间观看时长汇总记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_VIDEO_DATA_GET_MERGE_PLAYBACK_WATCH_RECORD)
    BjyResult<Void> getMergePlaybackWatchRecord(BjyPartnerInfo partnerInfo, GetMergePlaybackWatchRecordReq req);

    /**
     * API 6 : 查询指定观看过的回放视频列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_VIDEO_DATA_GET_PLAYBACK_VIDEO_WATCHED_LIST)
    BjyResult<Void> getPlaybackVideoWatchedList(BjyPartnerInfo partnerInfo, GetPlaybackVideoWatchedListReq req);

    /**
     * 点播/回放观看数据实时查询
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_VIDEO_DATA_GET_PLAYBACK_REALTIME_RECORD)
    BjyResult<TotalListResp<GetPlaybackRealtimeRecordDto>> getPlaybackRealtimeRecord(BjyPartnerInfo partnerInfo, GetPlaybackRealtimeRecordReq req);
}