package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.TotalListResp;
import com.baijiayun.openapi.sdk.dto.video.*;

import java.util.List;

/**
 * Auto generate interface of VideoApi.
 */
@BjyClient
public interface VideoApi {

    /**
     * API 85 : 自定义装修封面
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_85_VIDEO_SET_CUSTOMER_COVER)
    BjyResult<Void> setCustomerCover(BjyPartnerInfo partnerInfo, SetCustomerCoverReq req);

    /**
     * API-2: 获取视频上传地址
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_VIDEO_GET_UPLOAD_URL)
    BjyResult<GetUploadUrlResp> getUploadUrl(BjyPartnerInfo partnerInfo, GetUploadUrlReq req);

    /**
     * API-4: 获取断点续传地址
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_4_VIDEO_GET_RESUME_UPLOAD_URL)
    BjyResult<GetResumeUploadUrlResp> getResumeUploadUrl(BjyPartnerInfo partnerInfo, GetResumeUploadUrlReq req);

    /**
     * API-5: 查询视频转码状态
     * @param partnerInfo 百家云合作者参数
     * @param videoId [必填] video_id 视频id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_5_VIDEO_GET_STATUS)
    BjyResult<Void> getStatus(BjyPartnerInfo partnerInfo, @RequestParam("video_id") String videoId);

    /**
     * API-6: 获取指定ID视频信息
     * @param partnerInfo 百家云合作者参数
     * @param videoId [必填] video_id 视频id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_VIDEO_GET_INFO)
    BjyResult<GetInfoResp> getInfo(BjyPartnerInfo partnerInfo, @RequestParam("video_id") String videoId);

    /**
     * API-7: 获取指定ID视频截图
     * @param partnerInfo 百家云合作者参数
     * @param videoId [必填] video_id 视频id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_7_VIDEO_GET_IMAGE)
    BjyResult<Void> getImage(BjyPartnerInfo partnerInfo, @RequestParam("video_id") String videoId);

    /**
     * API-8: 清除指定清晰度的转码文件
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_8_VIDEO_REMOVE_DEFINITION)
    BjyResult<Void> removeDefinition(BjyPartnerInfo partnerInfo, RemoveDefinitionReq req);

    /**
     * API-9: 删除点播源文件
     * @param partnerInfo 百家云合作者参数
     * @param videoIds [必填] video_ids 多个video_id，用，分割
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_9_VIDEO_DELETE_ORIGIN_VIDEO)
    BjyResult<Void> deleteOriginVideo(BjyPartnerInfo partnerInfo, @RequestParam("video_ids") String videoIds);

    /**
     * API-10: 更新视频信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_10_VIDEO_UPDATE)
    BjyResult<Void> update(BjyPartnerInfo partnerInfo, UpdateReq req);

    /**
     * API-11: 删除视频
     * @param partnerInfo 百家云合作者参数
     * @param videoId [必填] video_id 视频id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_11_VIDEO_DELETE)
    BjyResult<Void> delete(BjyPartnerInfo partnerInfo, @RequestParam("video_id") String videoId);

    /**
     * API-12: 获取所有分类
     * @param partnerInfo 百家云合作者参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_12_VIDEO_GET_CATEGORY_LIST)
    BjyResult<VideoCategoryDtoResp> getCategoryList(BjyPartnerInfo partnerInfo);

    /**
     * API-13: 获取指定ID分类信息
     * @param partnerInfo 百家云合作者参数
     * @param categoryId 分类ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_13_VIDEO_GET_CATEGORY_INFO)
    BjyResult<Void> getCategoryInfo(BjyPartnerInfo partnerInfo, @RequestParam("category_id") Integer categoryId);

    /**
     * API-14: 添加分类
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_14_VIDEO_ADD_CATEGORY)
    BjyResult<Void> addCategory(BjyPartnerInfo partnerInfo, AddCategoryReq req);

    /**
     * API-15: 删除分类
     * @param partnerInfo 百家云合作者参数
     * @param categoryId [必填] category_id 分类ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_15_VIDEO_DELETE_CATEGORY)
    BjyResult<Void> deleteCategory(BjyPartnerInfo partnerInfo, @RequestParam("category_id") Integer categoryId);

    /**
     * API-16: 获取指定分类下的视频
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_16_VIDEO_GET_CATEGORY_VIDEO)
    BjyResult<GetVideoListResp> getCategoryVideo(BjyPartnerInfo partnerInfo, GetCategoryVideoReq req);

    /**
     * 获取点播播放地址
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_VIDEO_GET_PLAY_URL)
    BjyResult<VideoPlayUrlResp> getVideoPlayUrl(BjyPartnerInfo partnerInfo, VideoPlayUrlReq req);

    /**
     * API-17: 设置视频分类
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_17_VIDEO_SET_VIDEO_CATEGORY)
    BjyResult<Void> setVideoCategory(BjyPartnerInfo partnerInfo, SetVideoCategoryReq req);

    /**
     * API-18: 获取播放器token
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_18_VIDEO_GET_PLAYER_TOKEN)
    BjyResult<GetPlayerTokenResp> getPlayerToken(BjyPartnerInfo partnerInfo, GetPlayerTokenReq req);

    /**
     * API-19: 批量获取播放器token
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_19_VIDEO_GET_PLAYER_TOKEN_BATCH)
    BjyResult<Void> getPlayerTokenBatch(BjyPartnerInfo partnerInfo, GetPlayerTokenBatchReq req);

    /**
     * API-23: 获取转码后视频地址
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_23_VIDEO_GET_URL)
    BjyResult<Void> getUrl(BjyPartnerInfo partnerInfo, GetUrlReq req);

    /**
     * API 26: 设置视频发布状态
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_26_VIDEO_SET_PUBLISH_STATUS)
    BjyResult<Void> setPublishStatus(BjyPartnerInfo partnerInfo, SetPublishStatusReq req);

    /**
     * API-27: 获取视频分享地址
     * @param partnerInfo 百家云合作者参数
     * @param videoId [必填] video_id 视频ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_27_VIDEO_GET_SHARE_URL)
    BjyResult<Void> getShareUrl(BjyPartnerInfo partnerInfo, @RequestParam("video_id") String videoId);

    /**
     * API-31: 获取点播视频列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_31_VIDEO_GET_VIDEO_LIST)
    BjyResult<GetVideoListResp> getVideoList(BjyPartnerInfo partnerInfo, GetVideoListReq req);

    /**
     * API-32: 上传点播字幕文件
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_32_VIDEO_UPLOAD_SUBTITLE)
    BjyResult<Void> uploadSubtitle(BjyPartnerInfo partnerInfo, UploadSubtitleReq req);

    /**
     * 上传字幕链接
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_VIDEO_UPLOAD_SUBTITLE_BY_URL)
    BjyResult<Void> uploadSubtitleByUrl(BjyPartnerInfo partnerInfo, UploadSubtitleByUrlReq req);

    /**
     * API-33: 获取字幕文件列表
     * @param partnerInfo 百家云合作者参数
     * @param videoId [必填] video_id 视频id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_33_VIDEO_GET_SUBTITLE_LIST)
    BjyResult<Void> getSubtitleList(BjyPartnerInfo partnerInfo, @RequestParam("video_id") String videoId);

    /**
     * API-34: 更新点播字幕信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_34_VIDEO_UPDATE_SUBTITLE)
    BjyResult<Void> updateSubtitle(BjyPartnerInfo partnerInfo, UpdateSubtitleReq req);

    /**
     * API-35: 设置字幕为默认字幕
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_35_VIDEO_SET_DEFAULT_SUBTITLE)
    BjyResult<Void> setDefaultSubtitle(BjyPartnerInfo partnerInfo, SetDefaultSubtitleReq req);

    /**
     * API-36: 删除字幕文件
     * @param partnerInfo 百家云合作者参数
     * @param subtitleId [必填] subtitle_id 字幕id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_36_VIDEO_DELETE_SUBTITLE)
    BjyResult<Void> deleteSubtitle(BjyPartnerInfo partnerInfo, @RequestParam("subtitle_id") Integer subtitleId);

    /**
     * API-46:批量设置视频分类
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_46_VIDEO_SET_VIDEO_CATEGORY_BATCH)
    BjyResult<Void> setVideoCategoryBatch(BjyPartnerInfo partnerInfo, SetVideoCategoryBatchReq req);

    /**
     * API-47:设置三分屏信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_47_VIDEO_SET_TRIPARTITE_SCREEN)
    BjyResult<Void> setTripartiteScreen(BjyPartnerInfo partnerInfo, SetTripartiteScreenReq req);

    /**
     * API-48:点播设置打点接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_48_VIDEO_SET_VIDEO_KEY_FRAME)
    BjyResult<Void> setVideoKeyFrame(BjyPartnerInfo partnerInfo, SetVideoKeyFrameReq req);

    /**
     * API-49:获取打点数据列表
     * @param partnerInfo 百家云合作者参数
     * @param videoUnique [必填] video_unique 视频id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_49_VIDEO_LIST_VIDEO_KEY_FRAME)
    BjyResult<Void> listVideoKeyFrame(BjyPartnerInfo partnerInfo, @RequestParam("video_unique") String videoUnique);

    /**
     * API-50:设置点播打点跳转功能接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_50_VIDEO_SET_VIDEO_JUMP)
    BjyResult<Void> setVideoJump(BjyPartnerInfo partnerInfo, SetVideoJumpReq req);

    /**
     * API-51:获取点播评论token接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_51_VIDEO_GET_LOGIN_TOKEN)
    BjyResult<Void> getLoginToken(BjyPartnerInfo partnerInfo, GetLoginTokenReq req);

    /**
     * API-52:获取点播已关联白名单班级列表接口
     * @param partnerInfo 百家云合作者参数
     * @param videoUnique [必填] video_unique 视频id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_52_VIDEO_LIST_VIDEO_GROUP)
    BjyResult<Void> listVideoGroup(BjyPartnerInfo partnerInfo, @RequestParam("video_unique") String videoUnique);

    /**
     * API-53:班级关联点播白名单接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_53_VIDEO_ADD_VIDEO_GROUP)
    BjyResult<Void> addVideoGroup(BjyPartnerInfo partnerInfo, AddVideoGroupReq req);

    /**
     * API-54:移除点播白名单已绑定班级
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_54_VIDEO_REMOVE_VIDEO_GROUP)
    BjyResult<Void> removeVideoGroup(BjyPartnerInfo partnerInfo, RemoveVideoGroupReq req);

    /**
     * API-55:获取点播已关联白名单用户列表接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_55_VIDEO_GET_VIDEO_WHITE_LIST)
    BjyResult<Void> getVideoWhiteList(BjyPartnerInfo partnerInfo, GetVideoWhiteListReq req);

    /**
     * API-56:学员关联点播白名单接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_56_VIDEO_ADD_VIDEO_WHITE_LIST)
    BjyResult<Void> addVideoWhiteList(BjyPartnerInfo partnerInfo, AddVideoWhiteListReq req);

    /**
     * API-57:移除点播白名单学员接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_57_VIDEO_DELETE_VIDEO_WHITE_LIST)
    BjyResult<Void> deleteVideoWhiteList(BjyPartnerInfo partnerInfo, DeleteVideoWhiteListReq req);

    /**
     * 视频二次转码
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_VIDEO_TRANSCODE_AGAIN)
    BjyResult<Void> transcodeAgain(BjyPartnerInfo partnerInfo, TranscodeAgainReq req);

    /**
     * API 3:openapi 视频加密
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_3_VIDEO_SET_VIDEO_PASSWORD)
    BjyResult<Void> setVideoPassword(BjyPartnerInfo partnerInfo, SetVideoPasswordReq req);

    /**
     * 根据客户提供的视频url来生成点播视频
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_VIDEO_UPLOAD_VIDEO_WITH_URL)
    BjyResult<Void> uploadVideoWithUrl(BjyPartnerInfo partnerInfo, UploadVideoWithUrlReq req);

    /**
     * 视频id不变的情况下替换视频内容
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_VIDEO_REPLACE_VIDEO_KEEP_ID)
    BjyResult<Void> replaceVideoKeepId(BjyPartnerInfo partnerInfo, ReplaceVideoKeepIdReq req);

    /**
     * 批量发起点播生成字幕
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_VIDEO_BATCH_ADD_VIDEO_AUTO_SUBTITLE)
    BjyResult<Void> batchAddVideoAutoSubtitle(BjyPartnerInfo partnerInfo, BatchAddVideoAutoSubtitleReq req);

    /**
     * 批量发起回放生成字幕
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_VIDEO_BATCH_ADD_PLAYBACK_AUTO_SUBTITLE)
    BjyResult<Void> batchAddPlaybackAutoSubtitle(BjyPartnerInfo partnerInfo, BatchAddPlaybackAutoSubtitleReq req);

    /**
     * 字幕订单查询
     * @param partnerInfo 百家云合作者参数
     * @param orderId [必填] order_id 智能字幕订单 id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_VIDEO_GET_AUTO_SUBTITLE_ORDER_INFO)
    BjyResult<Void> getAutoSubtitleOrderInfo(BjyPartnerInfo partnerInfo, @RequestParam("order_id") String orderId);
}