package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.teacher.*;

/**
 * Auto generate interface of TeacherApi.
 */
@BjyClient
public interface TeacherApi {

    /**
     * API 5:老师添加、修改接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_5_TEACHER_SAVE)
    BjyResult<Void> save(BjyPartnerInfo partnerInfo, SaveReq req);

    /**
     * API 6:老师删除接口
     * @param partnerInfo 百家云合作者参数
     * @param teacherId [必填] teacher_id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_TEACHER_DELETE)
    BjyResult<Void> delete(BjyPartnerInfo partnerInfo, @RequestParam("teacher_id") Integer teacherId);

    /**
     * API 7:获取老师信息接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_7_TEACHER_LIST)
    BjyResult<Void> list(BjyPartnerInfo partnerInfo, ListReq req);
}