package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;

/**
 * Auto generate interface of SubAccountApi.
 */
@BjyClient
public interface SubAccountApi {

    /**
     * 查询子账号列表
     * @param partnerInfo 百家云合作者参数
     * @param status 账号状态 0:全部 1:使用中 2:停用或未开通的
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_SUB_ACCOUNT_GET_SUB_ACCOUNT_LIST)
    BjyResult<Void> getSubAccountList(BjyPartnerInfo partnerInfo, Integer status);

    /**
     * 获取子账号信息
     * @param partnerInfo 百家云合作者参数
     * @param subPartnerId [必填] sub_partner_id 子账号ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_SUB_ACCOUNT_GET_SUB_ACCOUNT_INFO)
    BjyResult<Void> getSubAccountInfo(BjyPartnerInfo partnerInfo, @RequestParam("sub_partner_id") Integer subPartnerId);
}