package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.smallcourse.*;

/**
 * Auto generate interface of SmallCourseApi.
 */
@BjyClient
public interface SmallCourseApi {

    /**
     * API 25 : 获取小班课账号每天消费记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_25_SMALL_COURSE_GET_DAILY_COST)
    BjyResult<Void> getDailyCost(BjyPartnerInfo partnerInfo, GetDailyCostReq req);

    /**
     * API 26 : 获取小班课指定日期各教室消费记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_26_SMALL_COURSE_GET_ROOM_COST)
    BjyResult<Void> getRoomCost(BjyPartnerInfo partnerInfo, GetRoomCostReq req);

    /**
     * API 27 : 获取小班课指定教室各学员消费详情
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_27_SMALL_COURSE_GET_USER_COST)
    BjyResult<Void> getUserCost(BjyPartnerInfo partnerInfo, GetUserCostReq req);

    /**
     * API 55 : 获取小班课录制费用
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_55_SMALL_COURSE_GET_PLAYBACK_DAILY_COST)
    BjyResult<Void> getPlaybackDailyCost(BjyPartnerInfo partnerInfo, GetPlaybackDailyCostReq req);
}