package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.reward.*;

/**
 * Auto generate interface of RewardApi.
 */
@BjyClient
public interface RewardApi {

    /**
     * API 117: 获取App打赏手机号账号余额接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_117_REWARD_GET_PHONE_ACCOUNT_INFO)
    BjyResult<Void> getPhoneAccountInfo(BjyPartnerInfo partnerInfo, GetPhoneAccountInfoReq req);

    /**
     * API 118: 获取App打赏手机号账号消费明细列表接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_118_REWARD_GET_PHONE_ACCOUNT_REWARD_LIST)
    BjyResult<Void> getPhoneAccountRewardList(BjyPartnerInfo partnerInfo, GetPhoneAccountRewardListReq req);

    /**
     * API 119: App打赏充值手机号账号接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_119_REWARD_RECHARGE_PHONE_ACCOUNT)
    BjyResult<Void> rechargePhoneAccount(BjyPartnerInfo partnerInfo, RechargePhoneAccountReq req);
}