package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.TotalListResp;
import com.baijiayun.openapi.sdk.dto.quiz.*;

/**
 * Auto generate interface of QuizApi.
 */
@BjyClient
public interface QuizApi {

    /**
     * API 14 : 小测关联直播间
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_14_QUIZ_ASSIGN_ROOM_PAPER)
    BjyResult<Void> assignRoomPaper(BjyPartnerInfo partnerInfo, AssignRoomPaperReq req);

    /**
     * API 15 : 查看教室小测
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_15_QUIZ_GET_ROOM_QUIZ_LIST)
    BjyResult<TotalListResp<GetRoomQuizListDto>> getRoomQuizList(BjyPartnerInfo partnerInfo, GetRoomQuizListReq req);

    /**
     * API 16 : 删除教室小测
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_16_QUIZ_BATCH_DELETE_ROOM_PAPER)
    BjyResult<Void> batchDeleteRoomPaper(BjyPartnerInfo partnerInfo, BatchDeleteRoomPaperReq req);
}