package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.partner.*;

/**
 * Auto generate interface of PartnerApi.
 */
@BjyClient
public interface PartnerApi {

    /**
     * API 1 : 获取/重置partner_key
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_PARTNER_CREATE_KEY)
    BjyResult<CreateKeyResp> createKey(BjyPartnerInfo partnerInfo, CreateKeyReq req);

    /**
     * API 22 : 获取账号配置项配置值
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_22_PARTNER_GET_PARTNER_CONFIG)
    BjyResult<Void> getPartnerConfig(BjyPartnerInfo partnerInfo, GetPartnerConfigReq req);
}