package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.TotalListResp;
import com.baijiayun.openapi.sdk.dto.notice.*;

/**
 * Auto generate interface of NoticeApi.
 */
@BjyClient
public interface NoticeApi {

    /**
     * API 17 : 查看教室公告
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_17_NOTICE_GET_ROOM_NOTICE_LIST)
    BjyResult<TotalListResp<GetRoomNoticeListDto>> getRoomNoticeList(BjyPartnerInfo partnerInfo, GetRoomNoticeListReq req);

    /**
     * API 18 : 绑定教室公告
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_18_NOTICE_ASSIGN_ROOM_NOTICE)
    BjyResult<Void> assignRoomNotice(BjyPartnerInfo partnerInfo, AssignRoomNoticeReq req);

    /**
     * API 19 : 删除教室公告
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_19_NOTICE_BATCH_DELETE_ROOM_NOTICE)
    BjyResult<Void> batchDeleteRoomNotice(BjyPartnerInfo partnerInfo, BatchDeleteRoomNoticeReq req);

    /**
     * API 69 : 获取主屏区公告ID
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_69_NOTICE_GET_ROLL_NOTICE_LIST)
    BjyResult<Void> getRollNoticeList(BjyPartnerInfo partnerInfo, GetRollNoticeListReq req);

    /**
     * API-41:设置滚动公告
     * @param partnerInfo 百家云合作者参数
     * @param notice [必填] notice 公告内容和链接
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_41_NOTICE_SET_ROLL_NOTICE)
    BjyResult<Void> setRollNotice(BjyPartnerInfo partnerInfo, String notice);

    /**
     * API-42:视频批量绑定公告
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_42_NOTICE_BATCH_SET_VIDEO_NOTICE)
    BjyResult<Void> batchSetVideoNotice(BjyPartnerInfo partnerInfo, BatchSetVideoNoticeReq req);
}