package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.mixedplayback.*;

/**
 * Auto generate interface of MixedPlaybackApi.
 */
@BjyClient
public interface MixedPlaybackApi {

    /**
     * 获取合并回放列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_MIXED_PLAYBACK_GET_LIST)
    BjyResult<Void> getList(BjyPartnerInfo partnerInfo, GetListReq req);

    /**
     * 获取合并回放详情
     * @param partnerInfo 百家云合作者参数
     * @param mixedPlaybackId [必填] mixed_playback_id 合并回放 id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_MIXED_PLAYBACK_GET_DETAIL)
    BjyResult<Void> getDetail(BjyPartnerInfo partnerInfo, @RequestParam("mixed_playback_id") String mixedPlaybackId);

    /**
     * 删除合并回放
     * @param partnerInfo 百家云合作者参数
     * @param mixedPlaybackId [必填] mixed_playback_id 合并回放 id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_MIXED_PLAYBACK_DELETE)
    BjyResult<Void> delete(BjyPartnerInfo partnerInfo, @RequestParam("mixed_playback_id") String mixedPlaybackId);

    /**
     * 创建合并回放
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_MIXED_PLAYBACK_CREATE)
    BjyResult<Void> create(BjyPartnerInfo partnerInfo, CreateReq req);
}