package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.TotalResp;
import com.baijiayun.openapi.sdk.dto.luckbag.*;

@BjyClient
public interface LuckyBagApi {

    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LUCKY_BAG_COUPON_CREATE)
    BjyResult<CouponCreateResp> couponCreate(BjyPartnerInfo partnerInfo, CouponCreateReq coupon);

    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LUCKY_BAG_COUPON_UPDATE)
    BjyResult<CouponCreateResp> couponUpdate(BjyPartnerInfo partnerInfo, CouponUpdateReq coupon);

    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LUCKY_BAG_COUPON_DEL)
    BjyResult<Void> couponDel(BjyPartnerInfo partnerInfo, @RequestParam("coupon_batch_no") String couponBatchNo);

    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LUCKY_BAG_BATCH_BIND_COUPON_TO_ROOM)
    BjyResult<TotalResp> batchBindCouponToRoom(BjyPartnerInfo partnerInfo, BatchBindCouponToRoomReq bindReq);

    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LUCKY_BAG_BATCH_UNBIND_COUPON_TO_ROOM)
    BjyResult<Void> batchUnbindCouponToRoom(BjyPartnerInfo partnerInfo, BatchUnbindCouponToRoomReq req);

    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LUCKY_BAG_COUPON_STATE_CALLBACK)
    BjyResult<Void> couponStateCallback(BjyPartnerInfo partnerInfo, StudentCouponStateCallbackReq req);

    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LUCKY_BAG_COUPON_DRAW_COUNT_CALLBACK)
    BjyResult<Void> couponDrawCountCallback(BjyPartnerInfo partnerInfo, CouponDrawCountCallbackReq req);

}
