package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.livechatkeyword.*;

import java.util.List;

/**
 * Auto generate interface of LiveChatKeywordApi.
 */
@BjyClient
public interface LiveChatKeywordApi {

    /**
     * 关键词列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_X_LIVE_CHAT_KEYWORD_KEYWORD_LIST)
    BjyResult<Void> keywordList(BjyPartnerInfo partnerInfo, KeywordListReq req);

    /**
     * 关键词添加
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_CHAT_KEYWORD_ADD_KEYWORD)
    BjyResult<Void> addKeyword(BjyPartnerInfo partnerInfo, AddKeywordReq req);

    /**
     * 关键词批量添加
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_CHAT_KEYWORD_BATCH_ADD_KEYWORD)
    BjyResult<List<BatchAddKeywordResp>> batchAddKeyword(BjyPartnerInfo partnerInfo, BatchAddKeywordReq req);

    /**
     * 关键词删除
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_CHAT_KEYWORD_DEL_KEYWORD)
    BjyResult<Void> delKeyword(BjyPartnerInfo partnerInfo, DelKeywordReq req);

    /**
     * 关键词批量删除
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_CHAT_KEYWORD_BATCH_DELETE_KEYWORD)
    BjyResult<Void> batchDeleteKeyword(BjyPartnerInfo partnerInfo, BatchDeleteKeywordReq req);
}