package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.live.*;

import java.util.List;
import java.util.Map;

/**
 * Auto generate interface of LiveApi.
 */
@BjyClient
public interface LiveApi {

    /**
     * API 15 : 获取直播教室当前上课状态
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_15_LIVE_GET_LIVE_STATUS)
    BjyResult<Void> getLiveStatus(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 16 : 获取老师是否在教室状态
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_16_LIVE_GET_TEACHER_ONLINE_STATUS)
    BjyResult<Void> getTeacherOnlineStatus(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 17 : 获取当前时间教室人数
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_17_LIVE_GET_USER_COUNT)
    BjyResult<Void> getUserCount(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 19 : 设置教室公告
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_19_LIVE_SET_NOTIFY)
    BjyResult<Void> setNotify(BjyPartnerInfo partnerInfo, SetNotifyReq req);

    /**
     * API 35 : 发送聊天消息接口
     * @param partnerInfo 百家云合作者参数
     * @param messageList [必填] message_list json字符串
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_35_LIVE_SEND_CHAT_MESSAGE)
    BjyResult<Map<String, String>> sendChatMessage(BjyPartnerInfo partnerInfo, @RequestParam("message_list") List<SendChatMessageDto> messageList);

    /**
     * API 44 : 停止直播教室的云端录制
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_44_LIVE_STOP_CLOUD_RECORD)
    BjyResult<Void> stopCloudRecord(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 45 : 直播教室的云端录制生成回放
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_45_LIVE_TRANS_CLOUD_RECORD)
    BjyResult<Void> transCloudRecord(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 62: 教室上课
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_62_LIVE_START_CLASS)
    BjyResult<Void> startClass(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 63: 教室下课
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_63_LIVE_STOP_CLASS)
    BjyResult<Void> stopClass(BjyPartnerInfo partnerInfo, StopClassReq req);

    /**
     * API 64 : 设置助教权限
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_64_LIVE_SET_ASSISTANT_PERMISSION)
    BjyResult<Void> setAssistantPermission(BjyPartnerInfo partnerInfo, SetAssistantPermissionReq req);

    /**
     * API 70 : 切换主讲人
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_70_LIVE_SWITCH_SPEAKER)
    BjyResult<Void> switchSpeaker(BjyPartnerInfo partnerInfo, SwitchSpeakerReq req);

    /**
     * API 86 : 撤回单条聊天消息接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_86_LIVE_REVOKE_CHAT_MESSAGE)
    BjyResult<Void> revokeChatMessage(BjyPartnerInfo partnerInfo, RevokeChatMessageReq req);

    /**
     * API 110 : 获取教室回放录制状态接口
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 房间号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_110_LIVE_GET_CLOUD_RECORD_STATUS)
    BjyResult<Void> getCloudRecordStatus(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 1 : 获取进出教室下载地址
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_LIVE_GET_PARTNER_ROOM_INFO_URL)
    BjyResult<Void> getPartnerRoomInfoUrl(BjyPartnerInfo partnerInfo, GetPartnerRoomInfoUrlReq req);

    /**
     * API-1:获取直播教室当前在线用户列表
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_LIVE_GET_USER_LIST)
    BjyResult<Void> getUserList(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * 直播自定义信令通过api的方式来发送内容
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SEND_CUSTOM_CAST)
    BjyResult<Void> sendCustomCast(BjyPartnerInfo partnerInfo, SendCustomCastReq req);

    /**
     * API 14:发送自定义广播信令
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_14_LIVE_SEND_BROADCAST)
    BjyResult<Void> sendBroadcast(BjyPartnerInfo partnerInfo, SendBroadcastReq req);

    /**
     * API 99: 获取教室拉流flv地址接口
     * @param partnerInfo 百家云合作者参数
     * @param roomIds [必填] room_ids 房间号，多个英文逗号分隔
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_99_LIVE_GET_ROOM_PULL_FLV_URL)
    BjyResult<Void> getRoomPullFlvUrl(BjyPartnerInfo partnerInfo, @RequestParam("room_ids") String roomIds);

    /**
     * 每分钟在线学生人数
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_GET_USER_COUNT_BY_MINUTE)
    BjyResult<Void> getUserCountByMinute(BjyPartnerInfo partnerInfo, GetUserCountByMinuteReq req);

    /**
     * 学生在直播间的进出时间区间段
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_X_LIVE_GET_USER_IN_OUT_RECORD)
    BjyResult<Void> getUserInOutRecord(BjyPartnerInfo partnerInfo, GetUserInOutRecordReq req);

    /**
     * 开启云端录制
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 房间ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_START_CLOUD_RECORD)
    BjyResult<Void> startCloudRecord(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);
}