package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.CallbackUrlResp;
import com.baijiayun.openapi.sdk.dto.liveaccount.*;

/**
 * Auto generate interface of LiveAccountApi.
 */
@BjyClient
public interface LiveAccountApi {

    /**
     * API 23 : 获取账号一天中每小时最高并发量
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_23_LIVE_ACCOUNT_GET_HOUR_PEAK_USER)
    BjyResult<Void> getHourPeakUser(BjyPartnerInfo partnerInfo, GetHourPeakUserReq req);

    /**
     * API 24 : 查询账号一段时间内每天的最高并发量
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_24_LIVE_ACCOUNT_GET_DAY_PEAK_USER)
    BjyResult<Void> getDayPeakUser(BjyPartnerInfo partnerInfo, GetDayPeakUserReq req);

    /**
     * API 26 : 查询直播账号每天使用的人次/点数（请参考使用最新API 109）
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_26_LIVE_ACCOUNT_GET_PARTNER_DAILY_COST)
    BjyResult<Void> getPartnerDailyCost(BjyPartnerInfo partnerInfo, GetPartnerDailyCostReq req);

    /**
     * API 27 : 查询直播账号指定日期中各教室使用的人次
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_27_LIVE_ACCOUNT_GET_ALL_ROOM_COST)
    BjyResult<Void> getAllRoomCost(BjyPartnerInfo partnerInfo, GetAllRoomCostReq req);

    /**
     * API 55 : 查询账号大班课一段时间内拉流总时长(分钟)
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_55_LIVE_ACCOUNT_GET_DAY_MEDIA_LENGTH)
    BjyResult<Void> getDayMediaLength(BjyPartnerInfo partnerInfo, GetDayMediaLengthReq req);

    /**
     * API 56 : 查询指定日期内所有教室的拉流总时长(分钟)
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_56_LIVE_ACCOUNT_GET_ALL_ROOM_MEDIA_LENGTH)
    BjyResult<Void> getAllRoomMediaLength(BjyPartnerInfo partnerInfo, GetAllRoomMediaLengthReq req);

    /**
     * API 67 : 获取专注度列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_67_LIVE_ACCOUNT_GET_ATTENTION_LIST)
    BjyResult<Void> getAttentionList(BjyPartnerInfo partnerInfo, GetAttentionListReq req);

    /**
     * API 109 : 获取账号直播人次统计数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_109_LIVE_ACCOUNT_GET_DATE_USER_COUNT)
    BjyResult<Void> getDateUserCount(BjyPartnerInfo partnerInfo, GetDateUserCountReq req);

    /**
     * 设置直播上下课事件回调地址
     * @param partnerInfo 百家云合作者参数
     * @param url [必填] url 回调地址，必须是http(s)://开头，http://y-test-api.baijiayun.com:8082/bjycb/callback.php
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_ACCOUNT_SET_CLASS_CALLBACK_URL)
    BjyResult<CallbackUrlResp> setClassCallbackUrl(BjyPartnerInfo partnerInfo, String url);

    /**
     * 查询直播上下课回调地址
     * @param partnerInfo 百家云合作者参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_ACCOUNT_GET_CLASS_CALLBACK_URL)
    BjyResult<CallbackUrlResp> getClassCallbackUrl(BjyPartnerInfo partnerInfo);

    /**
     * API 24 : 查询直播账号信息
     * @param partnerInfo 百家云合作者参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_24_LIVE_ACCOUNT_GET_ACCOUNT_INFO)
    BjyResult<Void> getAccountInfo(BjyPartnerInfo partnerInfo);
}