package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.h5template.*;
import com.baijiayun.openapi.sdk.dto.*;
import com.baijiayun.openapi.sdk.dto.livesetting.GetTemplateInfoDto;
import com.baijiayun.openapi.sdk.dto.livesetting.GetTemplateListDto;

/**
 * Auto generate interface of H5TemplateApi.
 */
@BjyClient
public interface H5TemplateApi {

    /**
     * API 1 : 获取全局自定义菜单模版列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_H5_TEMPLATE_GET_TEMPLATE_LIST)
    BjyResult<TotalListResp<GetTemplateListDto>> getTemplateList(BjyPartnerInfo partnerInfo, GetTemplateListReq req);

    /**
     * API 2 : 获取全局自定义菜单模版详情
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_H5_TEMPLATE_GET_TEMPLATE_INFO)
    BjyResult<GetTemplateInfoDto> getTemplateInfo(BjyPartnerInfo partnerInfo, GetTemplateInfoReq req);

    /**
     * API 3 : 创建全局自定义菜单模版
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_3_H5_TEMPLATE_CREATE_TEMPLATE)
    BjyResult<Void> createTemplate(BjyPartnerInfo partnerInfo, CreateTemplateReq req);

    /**
     * API 4 : 更新全局自定义菜单模版
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_4_H5_TEMPLATE_UPDATE_TEMPLATE_INFO)
    BjyResult<Void> updateTemplateInfo(BjyPartnerInfo partnerInfo, UpdateTemplateInfoReq req);

    /**
     * API 5 : 设置使用全局自定义菜单模版
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_5_H5_TEMPLATE_SET_TEMPLATE_STATUS)
    BjyResult<Void> setTemplateStatus(BjyPartnerInfo partnerInfo, SetTemplateStatusReq req);

    /**
     * API 6: 删除全局自定义菜单模版
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_H5_TEMPLATE_DELETE_TEMPLATE)
    BjyResult<Void> deleteTemplate(BjyPartnerInfo partnerInfo, DeleteTemplateReq req);

    /**
     * API 7 : 保存全局自定义菜单
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_7_H5_TEMPLATE_SAVE_MENU)
    BjyResult<Void> saveMenu(BjyPartnerInfo partnerInfo, SaveMenuReq req);

    /**
     * API 8 : 保存全局自定义菜单顺序
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_8_H5_TEMPLATE_SORT_MENU)
    BjyResult<Void> sortMenu(BjyPartnerInfo partnerInfo, SortMenuReq req);

    /**
     * API 9 : 删除全局自定义菜单
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_9_H5_TEMPLATE_DELETE_MENU)
    BjyResult<Void> deleteMenu(BjyPartnerInfo partnerInfo, DeleteMenuReq req);

    /**
     * API 10 : 重置全局自定义菜单状态
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_10_H5_TEMPLATE_RESET)
    BjyResult<Void> reset(BjyPartnerInfo partnerInfo, ResetReq req);
}