package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.fluency.*;

/**
 * Auto generate interface of FluencyApi.
 */
@BjyClient
public interface FluencyApi {

    /**
     * API 1 : 获取最近 3 分钟直播间网络情况数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_FLUENCY_GET_NETWORK_DATA)
    BjyResult<Void> getNetworkData(BjyPartnerInfo partnerInfo, GetNetworkDataReq req);

    /**
     * 获取教室维度的卡顿数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_FLUENCY_GET_ROOM_NETWORK_DATA)
    BjyResult<Void> getRoomNetworkData(BjyPartnerInfo partnerInfo, GetRoomNetworkDataReq req);
}