package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.evaluation.*;

/**
 * Auto generate interface of EvaluationApi.
 */
@BjyClient
public interface EvaluationApi {

    /**
     * API 50 : 获取课后评价模板列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_50_EVALUATION_GET_EVALUATION_LIST)
    BjyResult<Void> getEvaluationList(BjyPartnerInfo partnerInfo, GetEvaluationListReq req);

    /**
     * API 51 : 关联教室模板
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_51_EVALUATION_BIND_ROOM_EVALUATION)
    BjyResult<Void> bindRoomEvaluation(BjyPartnerInfo partnerInfo, BindRoomEvaluationReq req);

    /**
     * API 52 : 更换教室模板
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_52_EVALUATION_UPDATE_ROOM_EVALUATION)
    BjyResult<Void> updateRoomEvaluation(BjyPartnerInfo partnerInfo, UpdateRoomEvaluationReq req);

    /**
     * API 60 : 创建课后评价模板
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_60_EVALUATION_CREATE_ROOM_EVALUATION)
    BjyResult<Void> createRoomEvaluation(BjyPartnerInfo partnerInfo, CreateRoomEvaluationReq req);

    /**
     * API 18:导出课后评价学生回答统计
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_18_EVALUATION_EXPORT_ANSWER)
    BjyResult<Void> exportAnswer(BjyPartnerInfo partnerInfo, ExportAnswerReq req);
}